/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.Index;
import com.aptana.index.core.build.BuildContext;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.index.JSIndexQueryHelper;
import com.aptana.js.core.inferencing.JSPropertyCollection;
import com.aptana.js.core.inferencing.JSScope;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.TypeElement;
import com.aptana.js.core.parsing.ast.JSCommentNode;
import com.aptana.js.core.parsing.ast.JSFunctionNode;
import com.aptana.js.core.parsing.ast.JSParseRootNode;
import com.aptana.js.internal.core.index.JSIndexWriter;
import com.aptana.js.internal.core.inferencing.JSSymbolTypeInferrer;
import com.aptana.js.internal.core.parsing.sdoc.SDocParser;
import com.aptana.js.internal.core.parsing.sdoc.model.DocumentationBlock;
import com.aptana.js.internal.core.parsing.sdoc.model.Tag;
import com.aptana.js.internal.core.parsing.sdoc.model.TagType;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.xpath.ParseNodeXPath;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.jaxen.JaxenException;
import org.jaxen.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFileIndexingParticipant
extends AbstractFileIndexingParticipant {
    private static XPath LAMBDAS_IN_SCOPE;
    private JSIndexWriter indexWriter = new JSIndexWriter();
    private JSIndexQueryHelper queryHelper;

    static {
        try {
            LAMBDAS_IN_SCOPE = new ParseNodeXPath("invoke[position() = 1]/group/function|invoke[position() = 1]/function");
        }
        catch (JaxenException e) {
            IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (Throwable)e);
        }
    }

    protected JSScope getGlobals(IParseNode root) {
        if (root instanceof JSParseRootNode) {
            return ((JSParseRootNode)root).getGlobals();
        }
        return null;
    }

    public void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                sub.subTask(this.getIndexingMessage(index, context.getURI()));
                this.processParseResults(context, index, (IParseNode)context.getAST(), (IProgressMonitor)sub.newChild(20));
            }
            catch (CoreException coreException) {
                sub.done();
            }
        }
        finally {
            sub.done();
        }
    }

    private List<PropertyElement> processLambdas(Index index, JSScope globals, IParseNode node, URI location, IProgressMonitor monitor) {
        List<PropertyElement> result = Collections.emptyList();
        try {
            List functions;
            Object queryResult;
            Object object = queryResult = LAMBDAS_IN_SCOPE != null ? LAMBDAS_IN_SCOPE.evaluate((Object)node) : null;
            if (queryResult != null && !(functions = (List)queryResult).isEmpty()) {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(functions.size() * 11));
                result = new ArrayList<PropertyElement>(functions.size());
                for (JSFunctionNode function : functions) {
                    JSScope scope = globals.getScopeAtOffset(function.getBody().getStartingOffset());
                    sub.worked(1);
                    JSSymbolTypeInferrer infer = new JSSymbolTypeInferrer(scope, index, location, this.queryHelper);
                    result.addAll(this.processWindowAssignments(scope, infer, (IProgressMonitor)sub.newChild(5)));
                    result.addAll(this.processLambdas(index, globals, (IParseNode)function, location, (IProgressMonitor)sub.newChild(5)));
                }
            }
        }
        catch (JaxenException e) {
            IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (Throwable)e);
        }
        return result;
    }

    public void processParseResults(BuildContext context, Index index, IParseNode ast, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.queryHelper = new JSIndexQueryHelper(context.getProject());
        URI location = context.getURI();
        boolean traceEnabled = IdeLog.isTraceEnabled((Plugin)JSCorePlugin.getDefault(), (String)"com.aptana.js.core/debug/show_indexing_steps");
        if (traceEnabled) {
            String message = MessageFormat.format("Building symbol tables for file ''{0}'' for index ''{1}''", location.toString(), index.toString());
            IdeLog.logTrace((Plugin)JSCorePlugin.getDefault(), (String)message, (String)"com.aptana.js.core/debug/show_indexing_steps");
        }
        JSScope globals = this.getGlobals(ast);
        try {
            try {
                JSSymbolTypeInferrer symbolInferrer = new JSSymbolTypeInferrer(globals, index, location, this.queryHelper);
                if (globals != null) {
                    String message;
                    TypeElement globalType = JSTypeUtil.createGlobalType("Global");
                    if (sub.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (traceEnabled) {
                        message = MessageFormat.format("Processing globally declared variables and functions in file ''{0}'' for index ''{1}''", location.toString(), index.toString());
                        IdeLog.logTrace((Plugin)JSCorePlugin.getDefault(), (String)message, (String)"com.aptana.js.core/debug/show_indexing_steps");
                    }
                    for (PropertyElement property : symbolInferrer.getScopeProperties((IProgressMonitor)sub.newChild(25))) {
                        globalType.addProperty(property);
                    }
                    if (sub.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (traceEnabled) {
                        message = MessageFormat.format("Processing assignments to ''window'' in file ''{0}'' for index ''{1}''", location.toString(), index.toString());
                        IdeLog.logTrace((Plugin)JSCorePlugin.getDefault(), (String)message, (String)"com.aptana.js.core/debug/show_indexing_steps");
                    }
                    for (PropertyElement property : this.processWindowAssignments(globals, symbolInferrer, (IProgressMonitor)sub.newChild(25))) {
                        globalType.addProperty(property);
                    }
                    if (sub.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (traceEnabled) {
                        message = MessageFormat.format("Processing assignments to ''window'' within self-invoking function literals in file ''{0}'' for index ''{1}''", location.toString(), index.toString());
                        IdeLog.logTrace((Plugin)JSCorePlugin.getDefault(), (String)message, (String)"com.aptana.js.core/debug/show_indexing_steps");
                    }
                    for (PropertyElement property : this.processLambdas(index, globals, ast, location, (IProgressMonitor)sub.newChild(25))) {
                        globalType.addProperty(property);
                    }
                    if (traceEnabled) {
                        message = MessageFormat.format("Assigning user agents to properties in file ''{0}'' for index ''{1}''", location.toString(), index.toString());
                        IdeLog.logTrace((Plugin)JSCorePlugin.getDefault(), (String)message, (String)"com.aptana.js.core/debug/show_indexing_steps");
                    }
                    for (PropertyElement property : globalType.getProperties()) {
                        property.setHasAllUserAgents();
                    }
                    if (traceEnabled) {
                        message = MessageFormat.format("Writing indexing results to index ''{0}'' for file ''{1}''", index.toString(), location.toString());
                        IdeLog.logTrace((Plugin)JSCorePlugin.getDefault(), (String)message, (String)"com.aptana.js.core/debug/show_indexing_steps");
                    }
                    this.indexWriter.writeType(index, globalType, location);
                    sub.worked(5);
                }
                sub.setWorkRemaining(20);
                this.processModule(context, index, ast, location, globals, symbolInferrer, (IProgressMonitor)sub.newChild(20));
            }
            catch (OperationCanceledException oce) {
                IdeLog.logWarning((Plugin)JSCorePlugin.getDefault(), (String)MessageFormat.format("User cancelled indexing operation on {0}", context.getURI()));
                sub.done();
            }
        }
        finally {
            sub.done();
        }
    }

    protected void processModule(BuildContext context, Index index, IParseNode ast, URI location, JSScope globals, JSSymbolTypeInferrer infer, IProgressMonitor monitor) {
        Object exports;
        if (globals == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String moduleTypeName = JSTypeUtil.getUniqueTypeName(location.toString());
        TypeElement moduleType = new TypeElement();
        moduleType.setHasAllUserAgents();
        moduleType.setName(moduleTypeName);
        TypeElement moduleExportsType = new TypeElement();
        moduleExportsType.setHasAllUserAgents();
        moduleExportsType.setName(String.valueOf(moduleType.getName()) + ".exports");
        JSPropertyCollection module = globals.getSymbol("module");
        if (module != null) {
            exports = infer.getSymbolPropertyElement(module, "exports", (IProgressMonitor)sub.newChild(90));
            moduleType.addProperty((PropertyElement)exports);
            List<String> types = exports instanceof FunctionElement ? ((FunctionElement)exports).getReturnTypeNames() : ((PropertyElement)exports).getTypeNames();
            for (String type : types) {
                if (type.startsWith("Array<")) {
                    type = "Array";
                }
                moduleExportsType.addParentType(type);
            }
        } else {
            exports = globals.getSymbol("exports");
            if (exports == null) {
                return;
            }
            List<String> properties = ((JSPropertyCollection)exports).getPropertyNames();
            if (!CollectionsUtil.isEmpty(properties)) {
                int work = 90 / properties.size();
                for (String property : properties) {
                    PropertyElement propElement = infer.getSymbolPropertyElement((JSPropertyCollection)exports, property, (IProgressMonitor)sub.newChild(work));
                    moduleExportsType.addProperty(propElement);
                }
                List<PropertyElement> props = moduleExportsType.getProperties();
                for (PropertyElement prop : props) {
                    prop.setOwningType(moduleExportsType.getName());
                }
            }
            PropertyElement exportsElement = new PropertyElement();
            exportsElement.setIsInstanceProperty(true);
            exportsElement.setHasAllUserAgents();
            exportsElement.setName("exports");
            exportsElement.addType(moduleExportsType.getName());
            moduleType.addProperty(exportsElement);
        }
        sub.setWorkRemaining(10);
        PropertyElement idElement = new PropertyElement();
        idElement.setIsInstanceProperty(true);
        idElement.setHasAllUserAgents();
        idElement.setName("id");
        idElement.addType("String");
        String moduleId = this.getModuleId(context, index, ast, location);
        idElement.setDescription(moduleId);
        moduleExportsType.addProperty(idElement);
        PropertyElement uriElement = new PropertyElement();
        uriElement.setIsInstanceProperty(true);
        uriElement.setHasAllUserAgents();
        uriElement.setName("uri");
        uriElement.addType("String");
        uriElement.setDescription(location.toString());
        moduleExportsType.addProperty(uriElement);
        sub.worked(2);
        this.indexWriter.writeType(index, moduleExportsType, location);
        this.indexWriter.writeType(index, moduleType, location);
        sub.worked(5);
        index.addEntry("js.module_def", moduleTypeName, location);
    }

    private String getModuleId(BuildContext context, Index index, IParseNode ast, URI location) {
        IParseRootNode root = (IParseRootNode)ast;
        Object[] comments = root.getCommentNodes();
        if (!ArrayUtil.isEmpty((Object[])comments)) {
            Object[] objectArray = comments;
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                JSCommentNode commentNode;
                Object comment = objectArray[n2];
                if (comment instanceof JSCommentNode && (commentNode = (JSCommentNode)((Object)comment)).getNodeType() == 90) {
                    SDocParser parser = new SDocParser();
                    try {
                        String source = context.getContents().substring(commentNode.getStart(), commentNode.getEnd() + 1);
                        DocumentationBlock result = (DocumentationBlock)((Object)parser.parse(source));
                        List<Tag> moduleTags = result.getTags(TagType.MODULE);
                        if (!CollectionsUtil.isEmpty(moduleTags)) {
                            return moduleTags.get(0).getText();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        URI relativeToRoot = index.getRelativeDocumentPath(location);
        return Path.fromPortableString((String)relativeToRoot.getPath()).removeFileExtension().toPortableString();
    }

    private Collection<PropertyElement> processWindowAssignments(JSScope symbols, JSSymbolTypeInferrer symbolInferrer, IProgressMonitor monitor) {
        if (symbols == null || !symbols.hasLocalSymbol("window")) {
            return Collections.emptyList();
        }
        PropertyElement property = symbolInferrer.getSymbolPropertyElement("window", monitor);
        if (property == null) {
            return Collections.emptyList();
        }
        List<String> typeNames = property.getTypeNames();
        if (!CollectionsUtil.isEmpty(typeNames)) {
            return this.queryHelper.getTypeMembers(typeNames);
        }
        return Collections.emptyList();
    }
}

